def mtf_encode(data: bytes) -> bytes:
    if not data:
        return b""
    dictionary = list(range(256))
    result = bytearray()
    for byte in data:
        pos = dictionary.index(byte)
        result.append(pos)
        if pos > 0:
            dictionary.pop(pos)
            dictionary.insert(0, byte)
    return bytes(result)

def mtf_decode(data: bytes) -> bytes:
    if not data:
        return b""
    dictionary = list(range(256))
    result = bytearray()
    for pos in data:
        byte = dictionary[pos]
        result.append(byte)
        if pos > 0:
            dictionary.pop(pos)
            dictionary.insert(0, byte)
    return bytes(result)