def bwt_encode(data: bytes):
    n = len(data)
    if n == 0:
        return b"", 0
    data += b"\x00"
    n += 1
    rotations = [data[i:] + data[:i] for i in range(n)]
    rotations_sorted = sorted(rotations)
    last_column = bytes(row[-1] for row in rotations_sorted)
    original_index = rotations_sorted.index(data)
    return last_column, original_index

def bwt_decode(data: bytes, index: int) -> bytes:
    n = len(data)
    if n == 0:
        return b""
    table = [b"" for _ in range(n)]
    for _ in range(n):
        table = [bytes([data[i]]) + table[i] for i in range(n)]
        table = sorted(table)
    result = table[index]
    if result[-1] == 0:
        result = result[:-1]
    return result